<?php
/**
 * The code is based on simple product template from WooCommerce.
 *
 * @package Przelewy24
 */

defined( 'ABSPATH' ) || exit;

if ( ! isset( $post_data ) ) {
	throw new LogicException( 'The variable $post_data is not set.' );
}
if ( ! isset( $nonce_action ) ) {
	throw new LogicException( 'The variable $nonce_action is not set.' );
}

global $product;
global $userdata;

if ( ! $userdata || ! $product->is_purchasable() ) {
	return;
}

echo wc_get_stock_html( $product ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

if ( $product->is_in_stock() ) : ?>

	<?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>

	<form class="cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data'>
		<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

		<?php
		do_action( 'woocommerce_before_add_to_cart_quantity' );

		wp_nonce_field( $nonce_action );
		woocommerce_quantity_input(
			array(
				'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
				'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
				'input_value' => isset( $post_data['quantity'] ) ? wc_stock_amount( sanitize_text_field( wp_unslash( $post_data['quantity'] ) ) ) : $product->get_min_purchase_quantity(),
			)
		);

		do_action( 'woocommerce_after_add_to_cart_quantity' );
		?>

		<button type="submit" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" class="single_add_to_cart_button button alt"><?php echo esc_html( $product->single_add_to_cart_text() ); ?></button>

		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
	</form>

	<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>

<?php endif; ?>
